<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->double('amount');
			$table->string('client_transaction_number', 100);
			$table->string('vendor_transaction_number', 100)->nullable();
			$table->enum('status', array('1', '2', '3'));
			$table->double('commission');
			$table->double('vendor_amount');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}