<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function content()
    {
        return $this->hasOne('MessageParts');
    }

    public function type()
    {
        return $this->belongsTo('MessageType');
    }

    public function recipients()
    {
        return $this->hasMany('MessageRecipient');
    }

    public function channel()
    {
        return $this->belongsTo('MessageChannel');
    }

}