<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function meats()
	{
		return $this->hasMany('Users');
	}

	public function bankdetails()
	{
		return $this->hasOne('BankDetails');
	}

	public function shops()
	{
		return $this->hasMany('Shop');
	}

	public function orders()
	{
		return $this->belongsToMany('Orders');
	}

}