<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateStudentsTable extends Migration {

	public function up()
	{
		Schema::create('Students', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 255);
			$table->string('last_name');
			$table->string('email');
			$table->string('phone');
			$table->enum('gender', array('male', 'female'));
			$table->datetime('date_of_birth');
			$table->string('mother_tongue');
			$table->json('languages_known');
			$table->string('Nationality');
			$table->string('Country');
			$table->string('City_of_Residence');
			$table->enum('Passport_Status', array('1', '2', '3'));
			$table->boolean('Visa_Rejection');
			$table->string('files');
			$table->bigInteger('course_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Students');
	}
}