<?php

namespace App\Entities\Lecturers;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lecturer extends Eloquent {

	protected $table = 'lecturers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function courses()
	{
		return $this->hasMany('Course');
	}

	public function bookings()
	{
		return $this->hasMany('Booking');
	}

}