<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lesson extends Eloquent {

	protected $table = 'lessons';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function module()
	{
		return $this->belongsTo('Module');
	}

	public function course()
	{
		return $this->hasOne('Course');
	}

}