<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Module extends Eloquent {

	protected $table = 'modules';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function course()
	{
		return $this->belongsTo('Course');
	}

	public function lessons()
	{
		return $this->hasMany('Lesson');
	}

}