<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePagesTable extends Migration {

	public function up()
	{
		Schema::create('pages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uri', 255)->unique();
			$table->string('title', 255);
			$table->text('body')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('parent_id')->unsigned()->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('pages');
	}
}