<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealPlansTable extends Migration {

	public function up()
	{
		Schema::create('meal_plans', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250);
			$table->text('description')->nullable();
			$table->bigInteger('hotel_id')->unsigned();
			$table->integer('charge_type');
			$table->decimal('price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('meal_plans');
	}
}