<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 250);
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('minimum_nights');
			$table->integer('maximum_nights');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}