<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->text('description')->nullable();
			$table->string('title', 250);
			$table->string('coupon_code', 10);
			$table->datetime('start_date');
			$table->datetime('end_date');
			$table->integer('discount');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}