<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('meal_plans', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms_facilities', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('rooms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms_facilities', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms_bookings', function(Blueprint $table) {
			$table->foreign('room_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rooms_bookings', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('bookings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('meal_plans', function(Blueprint $table) {
			$table->dropForeign('meal_plans_hotel_id_foreign');
		});
		Schema::table('rooms', function(Blueprint $table) {
			$table->dropForeign('rooms_hotel_id_foreign');
		});
		Schema::table('rooms_facilities', function(Blueprint $table) {
			$table->dropForeign('rooms_facilities_room_id_foreign');
		});
		Schema::table('rooms_facilities', function(Blueprint $table) {
			$table->dropForeign('rooms_facilities_facility_id_foreign');
		});
		Schema::table('rooms_bookings', function(Blueprint $table) {
			$table->dropForeign('rooms_bookings_room_id_foreign');
		});
		Schema::table('rooms_bookings', function(Blueprint $table) {
			$table->dropForeign('rooms_bookings_booking_id_foreign');
		});
	}
}