<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEditedChordsTable extends Migration {

	public function up()
	{
		Schema::create('edited_chords', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('chord_id')->unsigned();
			$table->text('orginal_chord');
			$table->text('edited_chord');
			$table->string('album', 150)->nullable();
			$table->text('description');
			$table->smallInteger('pub_year')->unsigned()->nullable();
			$table->json('rhythm')->nullable();
			$table->text('reject_reason')->nullable();
			$table->tinyInteger('status')->unsigned()->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('edited_chords');
	}
}