<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $guarded = array('password');
	protected $hidden = array('password');

	public function favourites()
	{
		return $this->belongsToMany('Chord', 'favourites');
	}

	public function rates()
	{
		return $this->belongsToMany('Course', 'rates');
	}

	public function likes()
	{
		return $this->belongsToMany('Chord', 'likes');
	}

	public function edited_chords()
	{
		return $this->hasMany('EditedChord', 'user_id');
	}

	public function chords()
	{
		return $this->hasMany('Chord', 'user_id');
	}

}