<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMovingBetweenCitiesAnswersTable extends Migration {

	public function up()
	{
		Schema::create('moving_between_cities_answers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('moving_between_cities_form_name')->nullable();
			$table->string('stage')->nullable();
			$table->string('starting_point')->nullable();
			$table->string('arrival_point')->nullable();
			$table->string('operation_code')->nullable();
			$table->integer('time_range_from')->nullable();
			$table->integer('time_range_to');
			$table->integer('number_of_pilgrims_coming_to_mecca')->nullable();
			$table->integer('percent_of_pilgrims_coming_to_mecca')->nullable();
			$table->integer('time_period_for_the_arrival_of_pilgrims_from')->nullable();
			$table->integer('time_period_for_the_arrival_of_pilgrims_to')->nullable();
			$table->integer('target_number_of_pilgrims_per_day')->nullable();
			$table->integer('daily_departure_time_limit_from')->nullable();
			$table->string('daily_departure_time_limit_to')->nullable();
			$table->integer('daily_departure_pilgrims_number')->nullable();
			$table->string('operating_requirements')->nullable();
			$table->string('number_of_daily_buses')->nullable();
			$table->string('number_of_drivers')->nullable();
			$table->string('regimental_commanders_for_the_target_setting')->nullable();
			$table->integer('number_of_responses_to_the_bus')->nullable();
			$table->integer('number_of_guides')->nullable();
			$table->integer('assistant_regimental_commanders')->nullable();
			$table->string('Operation_capabilities')->nullable();
			$table->integer('manpower')->nullable();
			$table->string('devices')->nullable();
			$table->string('supervision_capabilities')->nullable();
			$table->string('manpower_supervision')->nullable();
			$table->integer('devices_supervision')->nullable();
			$table->string('challenges')->nullable();
			$table->string('solutions')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('moving_between_cities_answers');
	}
}