<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TcTrip extends Eloquent {

	protected $table = 'tc_trips';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('time_from', 'time_to', 'pilgrim_count', 'tc_form_id', 'tc_establishment_id');

	public function form()
	{
		return $this->belongsTo('App/Model\TcForm');
	}

}