<?php

namespace App/Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TransferPattern extends Eloquent {

	protected $table = 'transfer_pattern';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'moving_between_cities_answer_id', 'number_of_pilgrims');

	public function moving_between_cities_answer()
	{
		return $this->belongsTo('App/Model\MovingBetweenCitiesAnswer');
	}

}