<?php

namespace App/Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TcTrip extends Model 
{

    protected $table = 'tc_trips';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('time_from', 'time_to', 'pilgrim_count', 'tc_form_id', 'tc_establishment_id');

    public function form()
    {
        return $this->belongsTo('App/Model\TcForm');
    }

}