<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function paragraph()
	{
		return $this->hasOne('Paragraph');
	}

	public function user()
	{
		return $this->hasOne('User');
	}

	public function contract()
	{
		return $this->hasOne('Contract');
	}

}