<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contract extends Eloquent {

	protected $table = 'contracts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contractType()
	{
		return $this->hasOne('ContractType');
	}

	public function buildingType()
	{
		return $this->hasOne('BuildingType');
	}

	public function language()
	{
		return $this->hasOne('Languages');
	}

	public function building()
	{
		return $this->hasOne('App\Model\Building');
	}

}