<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('segments', function(Blueprint $table) {
			$table->foreign('road_id')->references('id')->on('roads')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('public_utilities', function(Blueprint $table) {
			$table->foreign('pub_ut_ty_id')->references('id')->on('public_utility_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('public_utilities', function(Blueprint $table) {
			$table->foreign('segment_id')->references('id')->on('segments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('segments', function(Blueprint $table) {
			$table->dropForeign('segments_road_id_foreign');
		});
		Schema::table('public_utilities', function(Blueprint $table) {
			$table->dropForeign('public_utilities_pub_ut_ty_id_foreign');
		});
		Schema::table('public_utilities', function(Blueprint $table) {
			$table->dropForeign('public_utilities_segment_id_foreign');
		});
	}
}