<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;

class AppGeokmer extends Model 
{

    protected $table = 'apps_geokmer';
    public $timestamps = false;

    public function suggestions_apps()
    {
        return $this->hasMany('SuggestionApp');
    }

    public function slides_app()
    {
        return $this->hasMany('SlideApp');
    }

    public function sous_categorie()
    {
        return $this->belongsTo('SousCategorie', 'sous_categorie_id');
    }

    public function notes_app()
    {
        return $this->hasMany('NoteApp');
    }

    public function likes_app()
    {
        return $this->hasMany('LikeApp');
    }

    public function telechargements()
    {
        return $this->hasMany('Telechargement');
    }

    public function commentaires_apps()
    {
        return $this->hasMany('CommentaireApp');
    }

}