<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('suggestions_app', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('slidess_app', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('apps_geokmer', function(Blueprint $table) {
			$table->foreign('sous_categories_id')->references('id')->on('sous_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recherches', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes_app', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes_app', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('likes_app', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('likes_app', function(Blueprint $table) {
			$table->foreign('Membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('telechargements', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('telechargements', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commentaires_app', function(Blueprint $table) {
			$table->foreign('app_id')->references('id')->on('apps_geokmer')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('commentaires_app', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sous_categories', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('departements', function(Blueprint $table) {
			$table->foreign('region_id')->references('id')->on('regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('arrondissements', function(Blueprint $table) {
			$table->foreign('departement_id')->references('id')->on('departements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('membre_abonnement', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('membre_abonnement', function(Blueprint $table) {
			$table->foreign('abonnement_id')->references('id')->on('abonnements')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('commentaires_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('commentaires_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('likes_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('likes_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notes_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notes_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('photos_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('points_interet', function(Blueprint $table) {
			$table->foreign('sous_categorie_id')->references('id')->on('sous_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('points_interet', function(Blueprint $table) {
			$table->foreign('arrondissement_id')->references('id')->on('arrondissements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('details_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sauvegardes_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sauvegardes_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('visites_lieu', function(Blueprint $table) {
			$table->foreign('lieu_id')->references('id')->on('points_interet')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('visites_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('conseils_avis_geokmer', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->foreign('sous_categorie_id')->references('id')->on('sous_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->foreign('arrondissement_id')->references('id')->on('arrondissements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->foreign('membre_id')->references('id')->on('membres')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('photos_lieu_new', function(Blueprint $table) {
			$table->foreign('new_lieu_id')->references('id')->on('suggestions_lieu')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('suggestions_app', function(Blueprint $table) {
			$table->dropForeign('suggestions_app_app_id_foreign');
		});
		Schema::table('slidess_app', function(Blueprint $table) {
			$table->dropForeign('slidess_app_app_id_foreign');
		});
		Schema::table('apps_geokmer', function(Blueprint $table) {
			$table->dropForeign('apps_geokmer_sous_categories_id_foreign');
		});
		Schema::table('recherches', function(Blueprint $table) {
			$table->dropForeign('recherches_membre_id_foreign');
		});
		Schema::table('notes_app', function(Blueprint $table) {
			$table->dropForeign('notes_app_app_id_foreign');
		});
		Schema::table('notes_app', function(Blueprint $table) {
			$table->dropForeign('notes_app_membre_id_foreign');
		});
		Schema::table('likes_app', function(Blueprint $table) {
			$table->dropForeign('likes_app_app_id_foreign');
		});
		Schema::table('likes_app', function(Blueprint $table) {
			$table->dropForeign('likes_app_Membre_id_foreign');
		});
		Schema::table('telechargements', function(Blueprint $table) {
			$table->dropForeign('telechargements_app_id_foreign');
		});
		Schema::table('telechargements', function(Blueprint $table) {
			$table->dropForeign('telechargements_membre_id_foreign');
		});
		Schema::table('commentaires_app', function(Blueprint $table) {
			$table->dropForeign('commentaires_app_app_id_foreign');
		});
		Schema::table('commentaires_app', function(Blueprint $table) {
			$table->dropForeign('commentaires_app_membre_id_foreign');
		});
		Schema::table('sous_categories', function(Blueprint $table) {
			$table->dropForeign('sous_categories_categorie_id_foreign');
		});
		Schema::table('departements', function(Blueprint $table) {
			$table->dropForeign('departements_region_id_foreign');
		});
		Schema::table('arrondissements', function(Blueprint $table) {
			$table->dropForeign('arrondissements_departement_id_foreign');
		});
		Schema::table('membre_abonnement', function(Blueprint $table) {
			$table->dropForeign('membre_abonnement_membre_id_foreign');
		});
		Schema::table('membre_abonnement', function(Blueprint $table) {
			$table->dropForeign('membre_abonnement_abonnement_id_foreign');
		});
		Schema::table('commentaires_lieu', function(Blueprint $table) {
			$table->dropForeign('commentaires_lieu_membre_id_foreign');
		});
		Schema::table('commentaires_lieu', function(Blueprint $table) {
			$table->dropForeign('commentaires_lieu_lieu_id_foreign');
		});
		Schema::table('likes_lieu', function(Blueprint $table) {
			$table->dropForeign('likes_lieu_lieu_id_foreign');
		});
		Schema::table('likes_lieu', function(Blueprint $table) {
			$table->dropForeign('likes_lieu_membre_id_foreign');
		});
		Schema::table('notes_lieu', function(Blueprint $table) {
			$table->dropForeign('notes_lieu_lieu_id_foreign');
		});
		Schema::table('notes_lieu', function(Blueprint $table) {
			$table->dropForeign('notes_lieu_membre_id_foreign');
		});
		Schema::table('photos_lieu', function(Blueprint $table) {
			$table->dropForeign('photos_lieu_lieu_id_foreign');
		});
		Schema::table('points_interet', function(Blueprint $table) {
			$table->dropForeign('points_interet_sous_categorie_id_foreign');
		});
		Schema::table('points_interet', function(Blueprint $table) {
			$table->dropForeign('points_interet_arrondissement_id_foreign');
		});
		Schema::table('details_lieu', function(Blueprint $table) {
			$table->dropForeign('details_lieu_lieu_id_foreign');
		});
		Schema::table('sauvegardes_lieu', function(Blueprint $table) {
			$table->dropForeign('sauvegardes_lieu_membre_id_foreign');
		});
		Schema::table('sauvegardes_lieu', function(Blueprint $table) {
			$table->dropForeign('sauvegardes_lieu_lieu_id_foreign');
		});
		Schema::table('visites_lieu', function(Blueprint $table) {
			$table->dropForeign('visites_lieu_lieu_id_foreign');
		});
		Schema::table('visites_lieu', function(Blueprint $table) {
			$table->dropForeign('visites_lieu_membre_id_foreign');
		});
		Schema::table('conseils_avis_geokmer', function(Blueprint $table) {
			$table->dropForeign('conseils_avis_geokmer_membre_id_foreign');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->dropForeign('suggestions_lieu_sous_categorie_id_foreign');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->dropForeign('suggestions_lieu_arrondissement_id_foreign');
		});
		Schema::table('suggestions_lieu', function(Blueprint $table) {
			$table->dropForeign('suggestions_lieu_membre_id_foreign');
		});
		Schema::table('photos_lieu_new', function(Blueprint $table) {
			$table->dropForeign('photos_lieu_new_new_lieu_id_foreign');
		});
	}
}