<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEvenementsTable extends Migration {

	public function up()
	{
		Schema::create('evenements', function(Blueprint $table) {
			$table->increments('id');
			$table->string('Nom');
			$table->string('type');
			$table->string('theme');
			$table->text('desc');
			$table->string('image');
			$table->datetime('date_debut');
			$table->datetime('date_fin');
			$table->string('locale')->default('fr');
			$table->string('organisateur');
			$table->string('nom_lieu');
			$table->string('quartier');
			$table->string('ville');
			$table->string('departement');
			$table->string('arrondissement');
			$table->string('phone1');
			$table->string('phone2');
			$table->text('autre_infos');
		});
	}

	public function down()
	{
		Schema::drop('evenements');
	}
}