<?php

namespace Content;

use Illuminate\Database\Eloquent\Model;

class Content extends Model 
{

    protected $table = 'contents';
    public $timestamps = true;
    protected $fillable = array('status_id', 'tone_id', 'level_id', 'lang_id', 'variant_id', 'key', 'user_id');

    public function status()
    {
        return $this->hasMany('Status', 'status_id');
    }

    public function level()
    {
        return $this->hasMany('Level', 'level_id');
    }

    public function tone()
    {
        return $this->hasMany('Tone', 'tone_id');
    }

    public function variant()
    {
        return $this->hasMany('Variant', 'variant_id');
    }

    public function user()
    {
        return $this->hasMany('User', 'user_id');
    }

    public function result()
    {
        return $this->hasMany('Result', 'content_id');
    }

}