<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Tarea extends Model 
{

    protected $table = 'tareas';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function estado()
    {
        return $this->belongsTo('App\Estado', 'id_estado');
    }

    public function proyecto()
    {
        return $this->belongsTo('App\Proyecto', 'id_proyecto');
    }

}