<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Tarea extends Eloquent {

	protected $table = 'tareas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function estado()
	{
		return $this->belongsTo('App\Estado', 'id_estado');
	}

	public function proyecto()
	{
		return $this->belongsTo('App\Proyecto', 'id_proyecto');
	}

}