<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Proyecto extends Eloquent {

	protected $table = 'proyectos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function cliente()
	{
		return $this->belongsTo('App\Proyecto', 'id_cliente');
	}

	public function tareas()
	{
		return $this->hasMany('App\Tarea', 'id_proyecto');
	}

}