<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('project_tasks', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('project_tasks', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('project_departments', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('project_departments', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('task_status_percentage_details', function(Blueprint $table) {
			$table->foreign('task_details_id')->references('id')->on('task_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_status_percentage_details', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('status')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('task_details', function(Blueprint $table) {
			$table->foreign('project_task_id')->references('id')->on('project_tasks')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_details', function(Blueprint $table) {
			$table->foreign('project_department_id')->references('id')->on('project_departments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_users', function(Blueprint $table) {
			$table->foreign('task_details_id')->references('id')->on('task_details')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('task_users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_user_id_foreign');
		});
		Schema::table('project_tasks', function(Blueprint $table) {
			$table->dropForeign('project_tasks_project_id_foreign');
		});
		Schema::table('project_tasks', function(Blueprint $table) {
			$table->dropForeign('project_tasks_user_id_foreign');
		});
		Schema::table('project_departments', function(Blueprint $table) {
			$table->dropForeign('project_departments_project_id_foreign');
		});
		Schema::table('project_departments', function(Blueprint $table) {
			$table->dropForeign('project_departments_department_id_foreign');
		});
		Schema::table('task_status_percentage_details', function(Blueprint $table) {
			$table->dropForeign('task_status_percentage_details_task_details_id_foreign');
		});
		Schema::table('task_status_percentage_details', function(Blueprint $table) {
			$table->dropForeign('task_status_percentage_details_status_id_foreign');
		});
		Schema::table('task_details', function(Blueprint $table) {
			$table->dropForeign('task_details_project_task_id_foreign');
		});
		Schema::table('task_details', function(Blueprint $table) {
			$table->dropForeign('task_details_project_department_id_foreign');
		});
		Schema::table('task_users', function(Blueprint $table) {
			$table->dropForeign('task_users_task_details_id_foreign');
		});
		Schema::table('task_users', function(Blueprint $table) {
			$table->dropForeign('task_users_user_id_foreign');
		});
	}
}