<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTaskStatusPercentageDetailsTable extends Migration {

	public function up()
	{
		Schema::create('task_status_percentage_details', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('task_details_id')->unsigned()->index();
			$table->integer('status_id')->unsigned()->nullable()->index();
			$table->decimal('percentage', 5,2)->nullable();
			$table->timestamps();
			$table->boolean('status')->index()->default(false);
		});
	}

	public function down()
	{
		Schema::drop('task_status_percentage_details');
	}
}