<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('package_no')->nullable();
			$table->string('project_owner')->nullable()->index();
			$table->string('epc_contractor')->nullable();
			$table->string('project_type')->nullable()->index();
			$table->date('starting_date')->nullable()->index();
			$table->string('construction_period')->nullable();
			$table->date('schedule_date_of_completion')->nullable();
			$table->string('project_location')->nullable();
			$table->decimal('progress', 5,2)->nullable();
			$table->integer('user_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}