<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDestinationTable extends Migration {

	public function up()
	{
		Schema::create('destination', function(Blueprint $table) {
			$table->increments('id_destination');
			$table->integer('id_des_cat');
			$table->integer('id_city');
			$table->string('title', 200);
			$table->string('min_purchase', 5);
			$table->string('max_purchase', 5);
			$table->string('price_per_person', 10);
			$table->text('description');
			$table->string('tour_status', 50);
			$table->string('map_lat', 15);
			$table->string('map_lng', 15);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('destination');
	}
}