<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('code', 191);
			$table->string('type', 191);
			$table->string('barcode_symbology', 191);
			$table->integer('brand_id');
			$table->integer('category_id');
			$table->integer('unit_id');
			$table->integer('purchase_unit_id');
			$table->integer('sale_unit_id');
			$table->string('cost', 191);
			$table->string('price', 191);
			$table->double('qty');
			$table->double('alert_quantity');
			$table->tinyInteger('promotion');
			$table->string('promotion_price', 191);
			$table->string('starting_date', 200);
			$table->date('last_date');
			$table->integer('tax_id');
			$table->integer('tax_method');
			$table->string('image', 191);
			$table->string('file', 191);
			$table->tinyInteger('featured');
			$table->string('product_list', 191);
			$table->string('qty_list', 191);
			$table->string('price_list', 191);
			$table->text('product_details');
			$table->text('product_invoice_details');
			$table->tinyInteger('is_active');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}