<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuotationsTable extends Migration {

	public function up()
	{
		Schema::create('quotations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('reference_no', 191);
			$table->integer('user_id');
			$table->integer('biller_id');
			$table->integer('supplier_id');
			$table->integer('customer_id');
			$table->integer('warehouse_id');
			$table->integer('item');
			$table->double('total_qty');
			$table->double('total_discount');
			$table->double('total_tax');
			$table->double('total_price');
			$table->double('order_tax_rate');
			$table->double('order_tax');
			$table->double('order_discount');
			$table->double('shipping_cost');
			$table->double('grand_total');
			$table->integer('quotation_status');
			$table->string('document', 191);
			$table->text('note');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('quotations');
	}
}