<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstallmentpaymentsTable extends Migration {

	public function up()
	{
		Schema::create('installmentpayments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('paid', 'partial', ''));
			$table->double('amount');
			$table->integer('installment_id');
			$table->string('note')->nullable();
			$table->integer('user_id');
		});
	}

	public function down()
	{
		Schema::drop('installmentpayments');
	}
}