<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Accounts extends Eloquent {

	protected $table = 'accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'open_balance', 'balance', 'user_id');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}