<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Clients extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'g_name', 'g_phone', 'g_address', 'code', 'phone', 'user_id');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}