<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Installmentitems extends Eloquent {

	protected $table = 'installmentitems';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('product_id', 'quantity', 'base_price', 'price', 'total_price', 'installment_id', 'user_id');

	public function product()
	{
		return $this->belongsTo('Products', 'product_id');
	}

	public function installment_invoice()
	{
		return $this->belongsTo('Installmentinvoices', 'installment_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}