<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoices extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'invoice_number', 'client_name', 'branch_id', 'user_id');

	public function branch()
	{
		return $this->belongsTo('Branches', 'branch_id');
	}

	public function items()
	{
		return $this->hasMany('Invoiceitems', 'invoice_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}