<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'store_id', 'buy_price', 'sell_price', 'code', 'user_id', 'quantity');

	public function store()
	{
		return $this->belongsTo('Stores', 'store_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}