<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ReturnedItems extends Eloquent {

	protected $table = 'returned_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('returned_id', 'product_id', 'price', 'quantity', 'total');

	public function returned()
	{
		return $this->belongsTo('Returned', 'returned_id');
	}

	public function product()
	{
		return $this->belongsTo('Products', 'product_id');
	}

}