<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Vendors extends Eloquent {

	protected $table = 'vendors';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone', 'code', 'user_id');

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}