<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoices extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'invoice_number', 'client_name', 'branch_id', 'user_id');

    public function branch()
    {
        return $this->belongsTo('Branches', 'branch_id');
    }

    public function items()
    {
        return $this->hasMany('Invoiceitems', 'invoice_id');
    }

    public function user()
    {
        return $this->belongsTo('Users', 'user_id');
    }

}