<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCajasTable extends Migration {

	public function up()
	{
		Schema::create('cajas', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_cliente')->unsigned()->nullable();
			$table->integer('id_status')->unsigned()->nullable();
			$table->integer('id_tipo_caja')->unsigned()->nullable();
			$table->integer('id_tamano_caja')->unsigned()->nullable();
			$table->string('foto_caja', 100);
			$table->string('color', 30);
			$table->string('marca', 60);
			$table->string('foto_marca', 100);
			$table->string('modelo', 60);
			$table->string('foto_modelo', 100);
			$table->string('num_caja', 10);
			$table->string('foto_num_caja', 100);
			$table->string('placas', 20);
			$table->string('foto_placas', 100);
			$table->string('vin', 50);
			$table->string('foto_vin', 100);
			$table->integer('id_usuario_registro')->unsigned()->nullable();
			$table->integer('id_usuario_ult_mod')->unsigned()->nullable();
			$table->text('comentarios');
			$table->string('marca_llanta1', 30);
			$table->string('marca_llanta2', 30);
			$table->string('marca_llanta4', 30);
			$table->string('marca_llanta5', 30);
			$table->string('marca_llanta6', 30);
			$table->string('marca_llanta7', 30);
			$table->string('marca_llanta8', 30);
			$table->string('marca_llanta9', 30);
			$table->string('marca_llanta10', 30);
			$table->string('marca_llanta11', 30);
			$table->string('marca_llanta12', 30);
			$table->string('marca_llanta_extra', 30);
			$table->string('foto_marca_llanta_extra', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cajas');
	}
}