<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserDiseaseTable extends Migration {

	public function up()
	{
		Schema::create('user_disease', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('disease_id')->unsigned();
			$table->integer('creator_id')->unsigned();
			$table->boolean('still_have');
			$table->string('condition', 250)->nullable();
			$table->integer('age_injury')->default('0');
			$table->string('treatment', 250)->nullable();
			$table->integer('doctor_id')->unsigned()->default('0');
			$table->integer('status')->default('0');
			$table->string('other_disease', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_disease');
	}
}