<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorInformationTable extends Migration {

	public function up()
	{
		Schema::create('doctor_information', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('speciality_id')->unsigned();
			$table->string('photo')->nullable();
			$table->integer('consultation_fees')->default('0');
			$table->string('experience', 250)->nullable();
			$table->string('bio', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('doctor_information');
	}
}