<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePrescriptionTable extends Migration {

	public function up()
	{
		Schema::create('prescription', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('doctor_id')->unsigned();
			$table->integer('case_id')->unsigned();
			$table->integer('consultation_id')->unsigned();
			$table->string('img', 250)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('prescription');
	}
}