<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('speciality_id')->unsigned();
			$table->string('question', 250);
			$table->integer('status')->default('0');
			$table->string('slug', 250);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}