<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserFamilyTable extends Migration {

	public function up()
	{
		Schema::create('user_family', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('patient_id')->unsigned();
			$table->integer('sub_disease_id')->unsigned();
			$table->integer('family_relationship_id')->unsigned();
			$table->string('condition', 250)->nullable();
			$table->string('name', 250)->nullable();
			$table->integer('age')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_family');
	}
}