<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Service extends Model 
{

    protected $table = 'services';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('is_financial_param', 'name', 'recommendations');

    public function companies()
    {
        return $this->belongsToMany('Company');
    }

    public function programs()
    {
        return $this->belongsToMany('Program');
    }

    public function templates()
    {
        return $this->hasMany('Template');
    }

}